package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.dto.eventDTO.DisplayEventDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DisplayLocalDTO;
import mk.ukim.finki.it.reservengo.model.domain.User;
import mk.ukim.finki.it.reservengo.service.intf.CustomerService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/customer")
@PreAuthorize("hasRole('CUSTOMER')")
public class CustomerController {

    private final CustomerService customerService;

    public CustomerController(CustomerService customerService) {
        this.customerService = customerService;
    }

    @GetMapping("/favourite-locals")
    public ResponseEntity<List<DisplayLocalDTO>> listFavouriteLocals(@AuthenticationPrincipal User user) {
        List<DisplayLocalDTO> list = customerService.listFavouriteLocals(user.getId());
        return new ResponseEntity<>(list, HttpStatus.OK);
    }

    @PostMapping("/favourite-locals/add/{id}")
    public ResponseEntity<Void> addFavouriteLocal(@AuthenticationPrincipal User user, @PathVariable Long id) {
        customerService.addFavouriteLocal(user.getId(), id);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @PostMapping("/favourite-locals/remove/{id}")
    public ResponseEntity<Void> removeFavouriteLocal(@AuthenticationPrincipal User user, @PathVariable Long id) {
        customerService.removeFavouriteLocal(user.getId(), id);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @GetMapping("/favourite-events")
    public ResponseEntity<List<DisplayEventDTO>> listFavouriteEvents(@AuthenticationPrincipal User user) {
        List<DisplayEventDTO> list = customerService.listFavouriteEvents(user.getId());
        return new ResponseEntity<>(list, HttpStatus.OK);
    }

    @PostMapping("/favourite-events/add/{id}")
    public ResponseEntity<Void> addFavouriteEvent(@AuthenticationPrincipal User user, @PathVariable Long id) {
        customerService.addFavouriteEvent(user.getId(), id);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @PostMapping("/favourite-events/remove/{id}")
    public ResponseEntity<Void> removeFavouriteEvent(@AuthenticationPrincipal User user, @PathVariable Long id) {
        customerService.removeFavouriteEvent(user.getId(), id);
        return new ResponseEntity<>(HttpStatus.OK);
    }
}