import { defineStore } from 'pinia'
import { config } from '@/constants/Api_config'

export const userStore = defineStore('userStore', {
  state() {
    return {
      data: {
        id: 0,
        firstName: '',
        lastName: '',
        email: '',
        phoneNumber: '',
        role: 'UN_AUTHENTICATED',
        token: null,
        logoUrl: null,
        profilePictureBase64Encoded: null,
      },
    }
  },
  actions: {
    setLocalStorage(jsonObject) {
      this.data = jsonObject
      //this.data.profilePictureBase64Encoded =

      if (this.data.logoUrl != null) {
        this.setProfilePicturePathToLocalStorage(this.data.logoUrl)
      }

      localStorage.setItem('userData', JSON.stringify(jsonObject))
    },
    removeProfilePictureFromLocaleStorage() {
      this.data.logoUrl = null
      localStorage.setItem('userData', JSON.stringify(this.data))
    },

    setNewEditedDataToLocalStorage(jsonObject) {
      const { firstName, lastName, phoneNumber } = jsonObject
      this.data.firstName = firstName
      this.data.lastName = lastName
      this.data.phoneNumber = phoneNumber

      localStorage.setItem('userData', JSON.stringify(this.data))
    },
    setNewEmailToLocalStorage(jsonObject) {
      const { email, jwt } = jsonObject
      this.data.email = email
      this.data.token = jwt

      localStorage.setItem('userData', JSON.stringify(this.data))
    },
    setProfilePicturePathToLocalStorage(profilePicturePath) {
      this.data.logoUrl = profilePicturePath
      localStorage.setItem('userData', JSON.stringify(this.data))
    },
    getLocalStorage() {
      let nonparsed = localStorage.getItem('userData')
      if (nonparsed !== null) {
        this.data = JSON.parse(nonparsed)
      }
    },
    clearLocalStorage() {
      this.data = {
        id: 0,
        firstName: '',
        lastName: '',
        email: '',
        phoneNumber: '',
        role: 'UN_AUTHENTICATED',
        token: null,
        logoUrl: null,
        profilePictureBase64Encoded: null,
      }
      localStorage.setItem('userData', JSON.stringify(this.data))
    },
  },
  getters: {
    getToken() {
      return 'Bearer ' + this.data.token
    },
    isLocaleManager() {
      return this.data.role === 'ROLE_LOCAL_MANAGER'
    },
    isLocaleWorker() {
      return this.data.role === 'ROLE_LOCAL_WORKER'
    },
    isCustomer() {
      return this.data.role === 'ROLE_CUSTOMER'
    },
    isAdmin() {
      return this.data.role === 'ROLE_ADMIN'
    },
  },
})
