package mk.ukim.finki.it.reservengo.service.intf;

import mk.ukim.finki.it.reservengo.dto.localDTO.CreateLocalDetailsDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DeleteLocalPhotosResultDTO;
import mk.ukim.finki.it.reservengo.model.domain.Local;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface LocalService {
    List<Local> listAll();

    Local findLocalById(Long id);

    void save(String name);

    Local edit(Long localId, CreateLocalDetailsDTO createLocalDetailsDTO);

    void delete(Long id);

    String addLogo(Long localId, MultipartFile multipartFile);

    void deleteLogo(Long localId);

    String addPhoto(Long localId, MultipartFile photoFile);

    DeleteLocalPhotosResultDTO deletePhotos(Long localId, List<String> photoUrls);
}