package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.dto.localDTO.CreateLocalDetailsDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DeleteLocalPhotosDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DeleteLocalPhotosResultDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DisplayLocalDetailsDTO;
import mk.ukim.finki.it.reservengo.model.domain.User;
import mk.ukim.finki.it.reservengo.service.intf.LocalManagerService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping("/api/local-manager")
@PreAuthorize("hasRole('LOCAL_MANAGER')")
public class LocalManagerController {

    private final LocalManagerService localManagerService;

    public LocalManagerController(LocalManagerService localManagerService) {
        this.localManagerService = localManagerService;
    }

    @GetMapping("/my-local")
    public ResponseEntity<DisplayLocalDetailsDTO> getLocalForManager(@AuthenticationPrincipal User user) {
        DisplayLocalDetailsDTO displayLocalDetailsDTO = DisplayLocalDetailsDTO.from(localManagerService.findLocalByManagerId(user.getId()));
        return new ResponseEntity<>(displayLocalDetailsDTO, HttpStatus.OK);
    }

    @PutMapping("/my-local/edit")
    public ResponseEntity<DisplayLocalDetailsDTO> editLocalInformation(@AuthenticationPrincipal User user, @RequestBody CreateLocalDetailsDTO createLocalDetailsDTO) {
        DisplayLocalDetailsDTO displayLocalDetailsDTO = DisplayLocalDetailsDTO.from(localManagerService.editLocal(user.getId(), createLocalDetailsDTO));
        return new ResponseEntity<>(displayLocalDetailsDTO, HttpStatus.OK);
    }

    @PostMapping("/upload-logo")
    public ResponseEntity<String> uploadLogo(@AuthenticationPrincipal User user, @RequestParam("logo") MultipartFile logoFile) {
        String logoUrl = localManagerService.uploadLocalLogo(user.getId(), logoFile);
        return new ResponseEntity<>(logoUrl, HttpStatus.OK);
    }

    @DeleteMapping("/delete-logo")
    public ResponseEntity<Void> deleteLocalLogo(@AuthenticationPrincipal User user) {
        localManagerService.deleteLocalLogo(user.getId());
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @PostMapping("/upload-photo")
    public ResponseEntity<String> uploadLocalPhotos(@AuthenticationPrincipal User user, @RequestParam("photo") MultipartFile photoFile) {
        String photoUrl = localManagerService.uploadLocalPhoto(user.getId(), photoFile);
        return new ResponseEntity<>(photoUrl, HttpStatus.OK);
    }

    @DeleteMapping("/delete-photos")
    public ResponseEntity<DeleteLocalPhotosResultDTO> deleteLocalPhotos(@AuthenticationPrincipal User user, @RequestBody DeleteLocalPhotosDTO deleteLocalPhotosDTO) {
        DeleteLocalPhotosResultDTO resultDTO = localManagerService.deleteLocalPhoto(user.getId(), deleteLocalPhotosDTO);
        return new ResponseEntity<>(resultDTO, HttpStatus.MULTI_STATUS);
    }
}
