import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

export type CreateReservationDTO = {
  localId: number | string
  timeOfReservation: string // ISO string
  tableId: number | string
  tableNumber?: number
  capacity?: number
}

export type ReservationStatus =
  | 'PENDING'
  | 'CONFIRMED'
  | 'CANCELLED'
  | string

export type DisplayReservationDTO = {
  id?: number | string
  localId?: number | string
  localName: string
  localLogo: string | null
  timeOfReservation: string
  tableNumber: number
  capacity: number
  status: ReservationStatus
  tableId?: number | string
}

export type EditReservationDTO = {
  timeOfReservation: string // ISO string
  tableId: number | string
}

class ReservationsRepository {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  // POST /api/reservations/make-reservation
  makeReservation(dto: CreateReservationDTO): Promise<any> {
    return this.httpClient.post('create', dto)
  }

  // GET /api/reservations
  listMyReservations(): Promise<DisplayReservationDTO[]> {
    return this.httpClient.get('')
  }

  // PUT /api/reservations/{id}/cancel
  cancelReservation(reservationId: number | string): Promise<void> {
    return this.httpClient.put(`${reservationId}/cancel`, null)
  }

  // GET /api/reservations/{id}
  getReservationDetails(reservationId: number | string): Promise<DisplayReservationDTO> {
    return this.httpClient.get(`${reservationId}`)
  }

  // PUT /api/reservations/{id}/edit
  editReservation(
    reservationId: number | string,
    dto: EditReservationDTO,
  ): Promise<DisplayReservationDTO> {
    return this.httpClient.put(`${reservationId}/edit`, dto)
  }

  // GET /api/reservations/{id}/edit-info
  getEditReservationInfo(reservationId: number | string): Promise<any> {
    return this.httpClient.get(`${reservationId}/edit-info`)
  }
}

export const useReservations = new ReservationsRepository(BASE_API_URL + '/api/customer/reservations')
