package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.dto.localDTO.CreateLocalDTO;
import mk.ukim.finki.it.reservengo.service.intf.AdminService;
import mk.ukim.finki.it.reservengo.service.intf.CustomerService;
import mk.ukim.finki.it.reservengo.service.intf.LocalService;
import org.springframework.stereotype.Service;

@Service
public class AdminServiceImpl implements AdminService {

    private final LocalService localService;

    public AdminServiceImpl(LocalService localService, CustomerService customerService) {
        this.localService = localService;
    }

    @Override
    public void addLocal(CreateLocalDTO localDTO) {
        localService.save(localDTO.name());
    }

    @Override
    public void deleteLocal(Long id) {
        localService.delete(id);
    }
}
