package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.dto.localDTO.DisplayLocalDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DisplayLocalDetailsDTO;
import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.service.intf.LocalService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/locals")
public class LocalController {

    private final LocalService localService;

    public LocalController(LocalService localService) {
        this.localService = localService;
    }

    @GetMapping
    public ResponseEntity<List<DisplayLocalDTO>> getLocals() {
        List<DisplayLocalDTO> displayLocalDTOList = DisplayLocalDTO.fromLocals(localService.listAll());
        return new ResponseEntity<>(displayLocalDTOList, HttpStatus.OK);
    }

    @GetMapping("/{id}")
    public ResponseEntity<DisplayLocalDetailsDTO> getLocalDetails(@PathVariable Long id) {
        DisplayLocalDetailsDTO local = DisplayLocalDetailsDTO.from(localService.getLocalById(id));
        return new ResponseEntity<>(local, HttpStatus.OK);
    }
}
