package mk.ukim.finki.it.reservengo.dto.contactDTO;

import mk.ukim.finki.it.reservengo.model.domain.Contact;

import java.util.Map;

public record DisplayContactDTO(
        String phone,
        String email,
        Map<String, String> socialLinks
) {
    public static DisplayContactDTO from(Contact contact) {
        return new DisplayContactDTO(
                contact.getPhone(),
                contact.getEmail(),
                contact.getSocialLinks()
        );
    }
}
