package mk.ukim.finki.it.reservengo.model.domain;

import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.ManyToOne;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import mk.ukim.finki.it.reservengo.model.enumerations.Position;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;

@EqualsAndHashCode(callSuper = true)
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Data
public class LocalWorker extends User {
    @ManyToOne
    private Local local;

    @Enumerated(EnumType.STRING)
    private Position position;

    public LocalWorker(String firstName, String lastName, String email, String password, String phoneNumber, Role userRole) {
        super(firstName, lastName, email, password, phoneNumber, userRole);
    }
}
