package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.dto.localDTO.CreateLocalDTO;
import mk.ukim.finki.it.reservengo.service.intf.AdminService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/admin")
@PreAuthorize("hasRole('ADMIN')")
public class AdminController {

    private final AdminService adminService;

    public AdminController(AdminService adminService) {
        this.adminService = adminService;
    }

    @PostMapping("/add")
    public ResponseEntity<Void> addLocal(@RequestBody CreateLocalDTO localDTO) {
        adminService.addLocal(localDTO);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @DeleteMapping("/delete/{id}")
    public ResponseEntity<Void> deleteLocal(@PathVariable Long id) {
        adminService.deleteLocal(id);
        return new ResponseEntity<>(HttpStatus.OK);
    }
}
