import { createRouter, createWebHistory } from 'vue-router'


import home_ from '@/components/Project/Restaurant/home_.vue'
import login_ from '@/components/Project/Auth/login_.vue'
import register_ from '@/components/Project/Auth/register_.vue'
import favourite_locals from '@/components/Project/Restaurant/favourite_locals.vue'
import my_reservations from '@/components/Project/Reservation/My_reservations.vue'
import Locale_ from '@/components/Project/Restaurant/Locale_.vue'
import AddRestaurant from "@/components/Project/Admin/AddRestaurant.vue";
import Profile_Page from '@/components/Project/Customer/Profile_Page.vue'

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes: [
    {
      path: '/favourite_locals',
      name: 'favourite_locals',
      component: favourite_locals,
      // route level code-splitting
      // this generates a separate chunk (About.[hash].js) for this route
      // which is lazy-loaded when the route is visited.

    },
    {
      path: '/my_reservations',
      name: 'my reservations',
      component: my_reservations,
    },
    {
      path: '/',
      name: 'home',
      component: home_,
    },
    {
      path: '/login',
      name: 'login',
      component: login_,
    },
    {
      path: '/register',
      name: 'register',
      component: register_,
    },
    {
      path: '/more_details',
      name: 'more_details',
      component: Locale_,
    },
    {
      path: '/addRestaurant',
      name: 'addRestaurant',
      component: AddRestaurant,
    },
    //Profile Page
    {
      path: '/profilePage',
      name: 'profilePage',
      component: Profile_Page,
    }
  ],
})

export default router
