package mk.ukim.finki.it.reservengo.model.domain;

import jakarta.persistence.*;
import lombok.*;
import mk.ukim.finki.it.reservengo.model.enumerations.EventStatus;

import java.time.LocalDateTime;

@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
public class Event {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private String name;

    private String description;

    private LocalDateTime eventStart;

    private LocalDateTime eventEnd;

    @ManyToOne
    private Local local;

    @Enumerated(EnumType.STRING)
    private EventStatus status;

}
