package mk.ukim.finki.it.reservengo.model.domain;

import jakarta.persistence.*;
import lombok.*;
import mk.ukim.finki.it.reservengo.model.enumerations.ReservationStatus;

import java.time.LocalDateTime;
import java.util.Map;

@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
public class Reservation {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @ManyToOne
    private Customer customer;

    @ManyToOne
    private Local local;

    private LocalDateTime timeOfRes;

    @ElementCollection
    @MapKeyColumn(name = "table_id")
    @Column(name = "num_people")
    private Map<Integer, Integer> reservedTables;

    @Enumerated(EnumType.STRING)
    private ReservationStatus status;

}
