package mk.ukim.finki.it.reservengo.dto.jwtDTO;

import mk.ukim.finki.it.reservengo.model.domain.Customer;
import mk.ukim.finki.it.reservengo.model.domain.LocalManager;
import mk.ukim.finki.it.reservengo.model.domain.LocalWorker;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;

public record JWTAuthenticationRequestDTO(
        String firstName,
        String lastName,
        String email,
        String password,
        String phoneNumber
) {


    public Customer toCustomer(String encodedPassword) {
        return new Customer(
                firstName,
                lastName,
                email,
                encodedPassword,
                phoneNumber,
                Role.ROLE_CUSTOMER
        );
    }

    public LocalWorker toLocalWorker(String encodedPassword) {
        return new LocalWorker(
                firstName,
                lastName,
                email,
                encodedPassword,
                phoneNumber,
                Role.ROLE_LOCAL_WORKER
        );
    }

    public LocalManager toLocalManager(String encodedPassword) {
        return new LocalManager(
                firstName,
                lastName,
                email,
                encodedPassword,
                phoneNumber,
                Role.ROLE_LOCAL_MANAGER
        );
    }
}
