package mk.ukim.finki.it.reservengo.web;

import mk.ukim.finki.it.reservengo.model.Customer;
import mk.ukim.finki.it.reservengo.model.User;
import mk.ukim.finki.it.reservengo.service.intf.CustomerService;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/customer")
@CrossOrigin(origins = "*")
public class CustomerController {

    private final CustomerService customerService;

    public CustomerController(CustomerService customerService) {
        this.customerService = customerService;
    }

    @GetMapping
    public ResponseEntity<?> getCustomer() {
        return ResponseEntity.ok("ok");
    }

    @GetMapping("/profile")
    public ResponseEntity<?> getUserProfile(@AuthenticationPrincipal User user) {
        System.out.println(user.getId());
        Customer userProfile = customerService.getCustomerProfile(user.getId());
        return ResponseEntity.ok(userProfile);
    }
}
