
import { defineStore } from 'pinia'



export const userStore = defineStore('userStore', {

  state() {
    return {

      data: {
        id: 0,
        firstName: "",
        lastName: "",
        email: "",
        phoneNumber: "",
        role: "UN_AUTHENTICATED",
        token: ""
      }

    }
  },
  actions: {

    setLocalStorage(jsonObject) {
      //console.log("Local Storage object", jsonObject)

      this.data = jsonObject

      console.log("Local Storage data", this.data.firstName, this.data.lastName)

      localStorage.setItem('userData', JSON.stringify(jsonObject));

    },
    setNewEditedDataToLocalStorage(jsonObject) {
      const {firstName, lastName, phoneNumber} = jsonObject;
      this.data.firstName = firstName;
      this.data.lastName = lastName;
      this.data.phoneNumber = phoneNumber;

      localStorage.setItem('userData', JSON.stringify(this.data));
    },
    setNewEmailToLocalStorage(jsonObject) {
      const {email, jwt} = jsonObject;
      this.data.email = email;
      this.data.token = jwt;

      localStorage.setItem('userData', JSON.stringify(this.data));
    },
    getLocalStorage() {
      let nonparsed = localStorage.getItem('userData');
      if (nonparsed !== null) {
        this.data = JSON.parse(nonparsed);
      }
    },
    clearLocalStorage() {

      this.data =  {
        id: 0,
        firstName: "",
        lastName: "",
        email: "",
        phoneNumber: "",
        role: "UN_AUTHENTICATED",
        token: ""
      }
      localStorage.setItem('userData', JSON.stringify(this.data));

    }



  },
  getters: {
    getToken(){
      return 'Bearer ' + this.data.token;
    }
  }






})
