package mk.ukim.finki.it.reservengo.dto.adminDTO;

import mk.ukim.finki.it.reservengo.model.domain.Local;

import java.util.List;

import static mk.ukim.finki.it.reservengo.constants.LocalDateTimeConstants.FORMATTER;

public record DisplayAdminLocalsDTO(
        Long localId,
        String localName,
        String localLogo,
        String createdAt,
        String modifiedAt
) {
    public static DisplayAdminLocalsDTO fromLocal(Local local) {
        return new DisplayAdminLocalsDTO(
                local.getId(),
                local.getName(),
                local.getLogoUrl(),
                local.getCreatedAt().format(FORMATTER),
                local.getModifiedAt().format(FORMATTER)
        );
    }

    public static List<DisplayAdminLocalsDTO> fromLocals(List<Local> locals) {
        return locals.stream()
                .map(DisplayAdminLocalsDTO::fromLocal)
                .toList();
    }
}
