package mk.ukim.finki.it.reservengo.model.domain;

import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embeddable;
import jakarta.persistence.MapKeyColumn;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Embeddable
public class Contact {
    private String phone;
    private String email;
    @ElementCollection
    @MapKeyColumn(name = "social_app_name")
    @Column(name = "social_app_link")
    private Map<String, String> socialLinks;
}
