package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.dto.adminDTO.DisplayAdminLocalsDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.CreateLocalDTO;
import mk.ukim.finki.it.reservengo.dto.userDTO.DisplayUserDTO;
import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.model.domain.LocalManager;
import mk.ukim.finki.it.reservengo.model.enumerations.Position;
import mk.ukim.finki.it.reservengo.model.exceptions.ManagerAlreadyAssignedException;
import mk.ukim.finki.it.reservengo.model.exceptions.ManagerNotAssignedException;
import mk.ukim.finki.it.reservengo.service.intf.AdminService;
import mk.ukim.finki.it.reservengo.service.intf.LocalManagerService;
import mk.ukim.finki.it.reservengo.service.intf.LocalService;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class AdminServiceImpl implements AdminService {

    private final LocalService localService;
    private final LocalManagerService localManagerService;

    public AdminServiceImpl(LocalService localService, LocalManagerService localManagerService) {
        this.localService = localService;
        this.localManagerService = localManagerService;
    }

    @Override
    public void addLocal(CreateLocalDTO localDTO) {
        localService.save(localDTO.name());
    }

    @Override
    public void deleteLocal(Long id) {
        localService.delete(id);
    }

    @Override
    public List<DisplayAdminLocalsDTO> getLocals() {
        return DisplayAdminLocalsDTO.fromLocals(localService.listAll());
    }

    @Override
    public List<DisplayUserDTO> findManagersByLocalId(Long localId) {
        List<LocalManager> managers = localManagerService.findAllByLocalId(localId);
        return DisplayUserDTO.fromUsers(managers);
    }

    @Override
    public void assignManagerToLocal(Long localId, Long managerId) {
        LocalManager manager = localManagerService.findManagerById(managerId);
        if (manager.getLocal() != null) {
            throw new ManagerAlreadyAssignedException(manager.getId(), manager.getLocal().getId());
        }
        Local local = localService.findLocalById(localId);
        manager.setLocal(local);
        manager.setPosition(Position.MANAGER);
        localManagerService.update(manager.getId(), manager);
    }

    @Override
    public void removeManagerFromLocal(Long managerId) {
        LocalManager manager = localManagerService.findManagerById(managerId);
        if (manager.getLocal() == null) {
            throw new ManagerNotAssignedException(manager.getId());
        }
        manager.setLocal(null);
        manager.setPosition(null);
        localManagerService.update(manager.getId(), manager);
    }
}
