package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.service.intf.LocalManagerService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@RestController
@RequestMapping("/api/local-managers")
public class LocalManagerController {

    private final LocalManagerService localManagerService;

    public LocalManagerController(LocalManagerService localManagerService) {
        this.localManagerService = localManagerService;
    }

    @PostMapping("/{localId}/upload-logo")
    public ResponseEntity<?> uploadLogo(@PathVariable Long localId,
                                        @RequestParam("logo") MultipartFile logoFile) {
        localManagerService.uploadLocalLogo(localId, logoFile);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping("/{localId}/delete-logo")
    public ResponseEntity<?> deleteLocalLogo(@PathVariable Long localId) {
        localManagerService.deleteLocalLogo(localId);
        return ResponseEntity.ok().build();
    }

    @PostMapping("/{localId}/upload-menu")
    public ResponseEntity<?> uploadMenu(@PathVariable Long localId,
                                        @RequestParam("menu") MultipartFile menuFile) {
        localManagerService.uploadLocalMenu(localId, menuFile);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping("/{localId}/delete-menu")
    public ResponseEntity<?> deleteMenu(@PathVariable Long localId) {
        localManagerService.deleteLocalMenuPhoto(localId);
        return ResponseEntity.ok().build();
    }

    @PostMapping("/{localId}/upload-photos")
    public ResponseEntity<?> uploadPhotos(@PathVariable Long localId,
                                          @RequestParam("photos") List<MultipartFile> photos) {
        localManagerService.uploadLocalPhotos(localId, photos);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping("/{localId}/delete-photos")
    public ResponseEntity<?> deletePhotos(@PathVariable Long localId,
                                          @RequestParam("photos") List<String> photoPaths) {
        localManagerService.deleteLocalPhotos(localId, photoPaths);
        return ResponseEntity.ok().build();
    }
}
