package mk.ukim.finki.it.reservengo.web;

import mk.ukim.finki.it.reservengo.service.intf.LocalService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api")
@CrossOrigin("*")
public class LocalController {

    private final LocalService localService;

    public LocalController(LocalService localService) {
        this.localService = localService;
    }

    @GetMapping("/locals")
    public ResponseEntity<?> getLocals(){
        return ResponseEntity.ok(localService.listAll());
    }
}
