package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.model.Local;
import mk.ukim.finki.it.reservengo.repository.LocalRepository;
import mk.ukim.finki.it.reservengo.service.intf.AdminService;
import org.springframework.stereotype.Service;

@Service
public class AdminServiceImpl implements AdminService {

    private final LocalRepository localRepository;

    public AdminServiceImpl(LocalRepository localRepository) {
        this.localRepository = localRepository;
    }

    @Override
    public void addLocal(String name) {
        Local local = new Local(name);
        localRepository.save(local);
    }

    @Override
    public void deleteLocal(Long id) {
        localRepository.deleteById(id);
    }
}
