package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.model.*;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;
import mk.ukim.finki.it.reservengo.model.exceptions.EmailNotFoundException;
import mk.ukim.finki.it.reservengo.repository.CustomerRepository;
import mk.ukim.finki.it.reservengo.repository.LocalManagerRepository;
import mk.ukim.finki.it.reservengo.repository.LocalWorkerRepository;
import mk.ukim.finki.it.reservengo.repository.UserRepository;
import mk.ukim.finki.it.reservengo.service.intf.AuthService;
import mk.ukim.finki.it.reservengo.service.intf.JWTService;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl implements AuthService {
    private final CustomerRepository customerRepository;
    private final LocalWorkerRepository localWorkerRepository;
    private final LocalManagerRepository localManagerRepository;
    private final JWTService jwtService;
    private final PasswordEncoder passwordEncoder;
    private final AuthenticationManager authenticationManager;
    private final UserRepository userRepository;

    public AuthServiceImpl(CustomerRepository customerRepository, LocalWorkerRepository localWorkerRepository, LocalManagerRepository localManagerRepository, JWTService jwtService, PasswordEncoder passwordEncoder, AuthenticationManager authenticationManager, UserRepository userRepository) {
        this.customerRepository = customerRepository;
        this.localWorkerRepository = localWorkerRepository;
        this.localManagerRepository = localManagerRepository;
        this.jwtService = jwtService;
        this.passwordEncoder = passwordEncoder;
        this.authenticationManager = authenticationManager;
        this.userRepository = userRepository;
    }

    @Override
    public JWTAuthenticationResponse registerCustomer(String firstName, String lastName, String email, String password, String phoneNumber) {
        Customer customer = new Customer(firstName, lastName, email, passwordEncoder.encode(password), phoneNumber, Role.ROLE_CUSTOMER);
        customerRepository.save(customer);
        String jwt = jwtService.generateTokenNoClaims(customer);

        System.out.println(jwt);
        System.out.println(customer);

        return new JWTAuthenticationResponse(
                customer.getId(),
                customer.getFirstName(),
                customer.getLastName(),
                customer.getEmail(),
                customer.getPhoneNumber(),
                Role.ROLE_CUSTOMER,
                jwt);
    }

    @Override
    public JWTAuthenticationResponse registerLocalWorker(String firstName, String lastName, String email, String password, String phoneNumber) {
        LocalWorker localWorker = new LocalWorker(firstName, lastName, email, passwordEncoder.encode(password), phoneNumber, Role.ROLE_LOCAL_WORKER);
        localWorkerRepository.save(localWorker);
        String jwt = jwtService.generateTokenNoClaims(localWorker);

        return new JWTAuthenticationResponse(
                localWorker.getId(),
                localWorker.getFirstName(),
                localWorker.getLastName(),
                localWorker.getEmail(),
                localWorker.getPhoneNumber(),
                Role.ROLE_LOCAL_WORKER,
                jwt);
    }

    @Override
    public JWTAuthenticationResponse registerLocalManager(String firstName, String lastName, String email, String password, String phoneNumber) {
        LocalManager localManager = new LocalManager(firstName, lastName, email, passwordEncoder.encode(password), phoneNumber, Role.ROLE_LOCAL_MANAGER);
        localManagerRepository.save(localManager);
        String jwt = jwtService.generateTokenNoClaims(localManager);

        return new JWTAuthenticationResponse(
                localManager.getId(),
                localManager.getFirstName(),
                localManager.getLastName(),
                localManager.getEmail(),
                localManager.getPhoneNumber(),
                Role.ROLE_LOCAL_MANAGER,
                jwt);
    }

    @Override
    public JWTAuthenticationResponse login(String email, String password) {
        authenticationManager.authenticate(new UsernamePasswordAuthenticationToken(email, password));
        User user = userRepository.findByEmail(email).orElseThrow(() -> new EmailNotFoundException(email));
        String jwt = jwtService.generateTokenNoClaims(user);

        return new JWTAuthenticationResponse(
                user.getId(),
                user.getFirstName(),
                user.getLastName(),
                user.getEmail(),
                user.getPhoneNumber(),
                user.getUserRole(),
                jwt);
    }
}
