package mk.ukim.finki.it.reservengo.web;

import mk.ukim.finki.it.reservengo.model.Reservation;
import mk.ukim.finki.it.reservengo.model.enumerations.ReservationStatus;
import mk.ukim.finki.it.reservengo.service.intf.ReservationService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api")
@CrossOrigin("*")
public class ReservationController {
    private final ReservationService reservationService;

    public ReservationController(ReservationService reservationService) {
        this.reservationService = reservationService;
    }

    //TODO RE-EVALUATE RESERVATIONS ARCHITECTURE

    @GetMapping("/reservations/{id}")
    public ResponseEntity<?> getReservationInformation(@PathVariable Long id) {
        Reservation reservation = reservationService.getReservationById(id);
        return ResponseEntity.ok(reservation);
    }

    @PostMapping("/reservations/{id}/status")
    public ResponseEntity<?> updateReservationStatus(@PathVariable Long id,
                                                     @RequestParam ReservationStatus status) {
        Reservation reservation = reservationService.getReservationById(id);
        reservation.setStatus(status);
        return ResponseEntity.ok(reservation);
    }

}
