package mk.ukim.finki.it.reservengo.web;

import mk.ukim.finki.it.reservengo.model.Local;
import mk.ukim.finki.it.reservengo.service.intf.LocalService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/locals")
@CrossOrigin("*")
public class LocalController {

    private final LocalService localService;

    public LocalController(LocalService localService) {
        this.localService = localService;
    }

    @GetMapping
    public ResponseEntity<?> getLocals() {
        return ResponseEntity.ok(localService.listAll());
    }

    @GetMapping("/{id}")
    public ResponseEntity<?> getLocalInformation(@PathVariable Long id) {
        Local local = localService.getLocalById(id);
        return ResponseEntity.ok(local);
    }


}
