package mk.ukim.finki.it.reservengo.service.impl;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import mk.ukim.finki.it.reservengo.service.intf.EmailService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class EmailServiceImpl implements EmailService {
    private final JavaMailSender mailSender;
    private final String frontEndUrl;

    public EmailServiceImpl(@Value("${frontend.url}") String frontEndUrl, JavaMailSender mailSender) {
        this.frontEndUrl = frontEndUrl;
        this.mailSender = mailSender;
    }

    @Override
    public void sendManagerInvitationEmail(String email, String token) throws MessagingException {
        String invitationUrl = frontEndUrl + "/register/manager?token=" + token;

        String html = """
                <div style="font-family: Arial, sans-serif; font-size: 15px; color: #333;">
                    <h2>Manager Invitation</h2>
                    <p>You have been invited to become a manager.</p>
                    <p>Click the button below to complete your registration:</p>
                    <a href="%s" style="
                        background-color: #4CAF50;
                        color: white;
                        padding: 10px 20px;
                        text-decoration: none;
                        border-radius: 5px;
                        display: inline-block;
                    ">Complete Registration</a>
                    <p style="margin-top: 20px;">This link will expire in 24 hours.</p>
                </div>
                """.formatted(invitationUrl);

        sendHtmlEmail(email, "Manager Invitation", html);
    }

    @Override
    public void sendWorkerInvitationEmail(String email, String token, String managerEmail, String localName) throws MessagingException {
        String invitationUrl = frontEndUrl + "/register/worker?token=" + token;

        String html = """
                <div style="font-family: Arial, sans-serif; font-size: 15px; color: #333;">
                    <h2>Worker Invitation</h2>
                    <p>You have been invited to become a worker at <b>%s</b>.</p>
                    <p>Invited by manager: <b>%s</b></p>
                    <p>Click the button below to complete your registration:</p>
                    <a href="%s" style="
                        background-color: #2196F3;
                        color: white;
                        padding: 10px 20px;
                        text-decoration: none;
                        border-radius: 5px;
                        display: inline-block;
                    ">Complete Registration</a>
                    <p style="margin-top: 20px;">This link will expire in 24 hours.</p>
                </div>
                """.formatted(localName, managerEmail, invitationUrl);

        sendHtmlEmail(email, "Worker Invitation", html);
    }

    @Override
    public void sendVerificationEmail(String email, String verificationCode) throws MessagingException {
        String verificationUrl = frontEndUrl + "/verify?code=" + verificationCode;

        String html = """
                <div style="font-family: Arial, sans-serif; font-size: 15px; color: #333;">
                    <h2>Email Verification</h2>
                    <p>Please verify your email address by clicking the button below:</p>
                    <a href="%s" style="
                        background-color: #FF9800;
                        color: white;
                        padding: 10px 20px;
                        text-decoration: none;
                        border-radius: 5px;
                        display: inline-block;
                    ">Verify Email</a>
                    <p style="margin-top: 20px;">
                        Or use this verification code:
                        <strong style="font-size: 18px; color: #FF9800;">%s</strong>
                    </p>
                    <p style="margin-top: 20px;">If you did not request this, you can ignore this email.</p>
                </div>
                """.formatted(verificationUrl, verificationCode);

        sendHtmlEmail(email, "Account verification", html);
    }

    private void sendHtmlEmail(String to, String subject, String text) throws MessagingException {
        try {
            MimeMessage message = mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");

            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(text, true);

            mailSender.send(message);
        } catch (MessagingException e) {
            throw new MessagingException("Failed to send email", e);
        }
    }
}
