package mk.ukim.finki.it.reservengo.service.intf;

import jakarta.mail.MessagingException;
import mk.ukim.finki.it.reservengo.dto.eventDTO.CreateEventDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.CreateLocalDetailsDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DeleteLocalPhotosDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DeleteLocalPhotosResultDTO;
import mk.ukim.finki.it.reservengo.dto.userDTO.EditUserEmailDTO;
import mk.ukim.finki.it.reservengo.dto.workerDTO.PositionDTO;
import mk.ukim.finki.it.reservengo.model.domain.Event;
import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.model.domain.LocalManager;
import mk.ukim.finki.it.reservengo.model.domain.LocalWorker;
import mk.ukim.finki.it.reservengo.model.enumerations.Position;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface LocalManagerService {
    void save(LocalManager localManager);

    List<LocalManager> findAllByLocalId(Long localId);

    LocalManager findManagerById(Long id);

    List<LocalManager> findAllUnassigned();

    void updateLocalAssignment(LocalManager manager, Local local, Position position);

    Local findLocalByManagerId(Long id);

    Local editLocal(Long managerId, CreateLocalDetailsDTO createLocalDetailsDTO);

    String uploadLocalLogo(Long managerId, MultipartFile logoFile);

    void deleteLocalLogo(Long managerId);

    String uploadLocalPhoto(Long managerId, MultipartFile photoFile);

    DeleteLocalPhotosResultDTO deleteLocalPhoto(Long managerId, DeleteLocalPhotosDTO deleteLocalPhotosDTO);

    void addEvent(Long managerId, CreateEventDTO createEventDTO);

    void deleteEvent(Long managerId, Long eventId);

    Event editEvent(Long managerId, Long eventId, CreateEventDTO createEventDTO);

    List<LocalWorker> findWorkersByLocal(Local local);

    List<LocalWorker> findUnassignedWorkers();

    void assignWorkerToLocal(Local local, Long workerId);

    void removeWorkerFromLocal(Long managerId, Long workerId);

    void changePosition(Long managerId, Long workerId, PositionDTO positionDTO);

    void inviteWorker(Long managerId, EditUserEmailDTO emailDTO) throws MessagingException;
}
