package mk.ukim.finki.it.reservengo.web.controller;

import jakarta.mail.MessagingException;
import mk.ukim.finki.it.reservengo.dto.adminDTO.DisplayAdminLocalsDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.CreateLocalDTO;
import mk.ukim.finki.it.reservengo.dto.userDTO.DisplayUserDTO;
import mk.ukim.finki.it.reservengo.dto.userDTO.EditUserEmailDTO;
import mk.ukim.finki.it.reservengo.service.intf.AdminService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/admin")
@PreAuthorize("hasRole('ADMIN')")
public class AdminController {

    private final AdminService adminService;

    public AdminController(AdminService adminService) {
        this.adminService = adminService;
    }

    @PostMapping("/add-local")
    public ResponseEntity<Void> addLocal(@RequestBody CreateLocalDTO localDTO) {
        adminService.addLocal(localDTO);
        return new ResponseEntity<>(HttpStatus.CREATED);
    }

    @DeleteMapping("/delete-local/{id}")
    public ResponseEntity<Void> deleteLocal(@PathVariable Long id) {
        adminService.deleteLocal(id);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @GetMapping("/locals")
    public ResponseEntity<List<DisplayAdminLocalsDTO>> getLocals() {
        List<DisplayAdminLocalsDTO> locals = adminService.getLocals();
        return new ResponseEntity<>(locals, HttpStatus.OK);
    }

    @GetMapping("/local-managers/{id}")
    public ResponseEntity<List<DisplayUserDTO>> getManagersForLocal(@PathVariable Long id) {
        List<DisplayUserDTO> managers = adminService.findManagersByLocalId(id);
        return new ResponseEntity<>(managers, HttpStatus.OK);
    }

    @GetMapping("/local-managers")
    public ResponseEntity<List<DisplayUserDTO>> getManagers() {
        List<DisplayUserDTO> managers = adminService.findUnassignedManagers();
        return new ResponseEntity<>(managers, HttpStatus.OK);
    }

    @PostMapping("/assign/{localId}/{managerId}")
    public ResponseEntity<Void> assignManagerToLocal(@PathVariable Long localId, @PathVariable Long managerId) {
        adminService.assignManagerToLocal(localId, managerId);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @DeleteMapping("/remove/{managerId}")
    public ResponseEntity<Void> removeManagerFromLocal(@PathVariable Long managerId) {
        adminService.removeManagerFromLocal(managerId);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @PostMapping("/invite-manager")
    public ResponseEntity<Void> inviteManager(@RequestBody EditUserEmailDTO emailDTO) throws MessagingException {
        adminService.inviteManager(emailDTO);
        return new ResponseEntity<>(HttpStatus.OK);
    }
}
