import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

class Admin {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  inviteManager(newEmail: string): Promise<any> {
    return this.httpClient.post('invite-manager', { newEmail })
  }
  addRestaurant(name: string): Promise<any> {
    return this.httpClient.post('add-local', { name })
  }

  async deleteRestaurant(localId: number): Promise<any> {
    return this.httpClient.delete(`delete-local/${localId}`)
  }

  fetchRestaurants(): Promise<any> {
    return this.httpClient.get('locals')
  }

  fetchLocalMangers(): Promise<any> {
    return this.httpClient.get('local-managers')
  }

  fetchManagersForRestaurant(localId: number): Promise<any> {
    return this.httpClient.get(`local-managers/${localId}`)
  }

  async assignManager(localId: number, managerId: number): Promise<any> {
    return this.httpClient.post(`assign/${localId}/${managerId}`)
  }

  async removeManager(managerId : number) {
    return this.httpClient.delete(`remove/${managerId}`)
  }
}

export const useAdmin = new Admin(BASE_API_URL + '/api/admin')
