package mk.ukim.finki.it.reservengo.dto.jwtDTO;

import mk.ukim.finki.it.reservengo.model.domain.Customer;
import mk.ukim.finki.it.reservengo.model.domain.LocalManager;
import mk.ukim.finki.it.reservengo.model.domain.LocalWorker;
import mk.ukim.finki.it.reservengo.model.enumerations.Provider;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;

public record JWTAuthenticationRequestDTO(
        String firstName,
        String lastName,
        String email,
        String password,
        String phoneNumber
) {


    public Customer toCustomer(String encodedPassword, Provider provider, String providerId) {
        return new Customer(
                firstName,
                lastName,
                email,
                encodedPassword,
                phoneNumber,
                Role.ROLE_CUSTOMER,
                provider,
                providerId
        );
    }

    public LocalWorker toLocalWorker(String encodedPassword, Provider provider, String providerId) {
        return new LocalWorker(
                firstName,
                lastName,
                email,
                encodedPassword,
                phoneNumber,
                Role.ROLE_LOCAL_WORKER,
                provider,
                providerId
        );
    }

    public LocalManager toLocalManager(String encodedPassword, Provider provider, String providerId) {
        return new LocalManager(
                firstName,
                lastName,
                email,
                encodedPassword,
                phoneNumber,
                Role.ROLE_LOCAL_MANAGER,
                provider,
                providerId
        );
    }
}
