package mk.ukim.finki.it.reservengo.model.domain;

import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.ManyToOne;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import mk.ukim.finki.it.reservengo.model.enumerations.Position;
import mk.ukim.finki.it.reservengo.model.enumerations.Provider;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;

@EqualsAndHashCode(callSuper = true)
@Entity
@NoArgsConstructor
@AllArgsConstructor
@Data
public class LocalManager extends User {
    @ManyToOne
    private Local local;

    @Enumerated(EnumType.STRING)
    private Position position;

    public LocalManager(String firstName, String lastName, String email, String password, String phoneNumber, Role userRole, Provider provider, String providerId) {
        super(firstName, lastName, email, password, phoneNumber, userRole, provider, providerId);
    }
}
