package mk.ukim.finki.it.reservengo.service.intf;

import jakarta.mail.MessagingException;
import mk.ukim.finki.it.reservengo.dto.jwtDTO.JWTAuthenticationRequestDTO;
import mk.ukim.finki.it.reservengo.dto.jwtDTO.JWTAuthenticationResponseDTO;
import mk.ukim.finki.it.reservengo.dto.jwtDTO.JWTLoginDTO;

public interface AuthService {
    JWTAuthenticationResponseDTO registerCustomer(JWTAuthenticationRequestDTO jwtAuthenticationRequestDTO) throws MessagingException;

    JWTAuthenticationResponseDTO registerLocalWorker(JWTAuthenticationRequestDTO jwtAuthenticationRequestDTO, String token);

    JWTAuthenticationResponseDTO registerLocalManager(JWTAuthenticationRequestDTO jwtAuthenticationRequestDTO, String token);

    JWTAuthenticationResponseDTO login(JWTLoginDTO jwtLoginDTO) throws MessagingException;

    void reactivateProfile(JWTLoginDTO jwtLoginDTO);

    void verifyCustomer(String email, String verificationCode) throws MessagingException;

    void resendVerificationCode(String email) throws MessagingException;

    JWTAuthenticationResponseDTO registerGoogleCustomer(String idToken);

    JWTAuthenticationResponseDTO registerGoogleLocalWorker(String idToken, String inviteToken);

    JWTAuthenticationResponseDTO registerGoogleLocalManager(String idToken, String inviteToken);

    JWTAuthenticationResponseDTO loginWithGoogle(String idToken);
}
