package mk.ukim.finki.it.reservengo.service.intf;

import mk.ukim.finki.it.reservengo.dto.workerDTO.DisplayLocalReservationDTO;
import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.model.domain.LocalWorker;
import mk.ukim.finki.it.reservengo.model.enumerations.Position;
import mk.ukim.finki.it.reservengo.model.enumerations.ReservationStatus;

import java.util.List;

public interface LocalWorkerService {
    void save(LocalWorker localWorker);

    LocalWorker findWorkerById(Long id);

    void changePosition(LocalWorker worker, Position position);

    List<LocalWorker> findAllByLocalId(Long id);

    List<LocalWorker> findAllUnassigned();

    void updateLocalAssignment(LocalWorker worker, Local local);

    List<DisplayLocalReservationDTO> viewLocalReservations(Long id, ReservationStatus status);

    void validateWorker(Long id,Long localId);

    void acceptReservation(Long id,Long reservationId);

    void denyReservation(Long id,Long reservationId);

    void finishReservation(Long id, Long reservationId);
}
