package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.dto.workerDTO.DisplayLocalReservationDTO;
import mk.ukim.finki.it.reservengo.model.domain.User;
import mk.ukim.finki.it.reservengo.model.enumerations.ReservationStatus;
import mk.ukim.finki.it.reservengo.service.intf.LocalWorkerService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/local-worker")
public class LocalWorkerController {
    private final LocalWorkerService localWorkerService;

    public LocalWorkerController(LocalWorkerService localWorkerService) {
        this.localWorkerService = localWorkerService;
    }

    @GetMapping("/{localId}/reservations")
    public ResponseEntity<List<DisplayLocalReservationDTO>> viewLocalReservations(@PathVariable Long localId, @RequestParam(required = false) ReservationStatus status,@AuthenticationPrincipal User user) {
        localWorkerService.validateWorker(user.getId(), localId);
        List<DisplayLocalReservationDTO> reservations = localWorkerService.viewLocalReservations(localId,status);
        return new ResponseEntity<>(reservations, HttpStatus.OK);
    }

    @PutMapping("/reservations/{reservationId}/accept")
    public ResponseEntity<Void> acceptReservation(@PathVariable Long reservationId, @AuthenticationPrincipal User user) {
        localWorkerService.acceptReservation(user.getId(), reservationId);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @PutMapping("/reservations/{reservationId}/deny")
    public ResponseEntity<Void> denyReservation(@PathVariable Long reservationId, @AuthenticationPrincipal User user) {
        localWorkerService.denyReservation(user.getId(), reservationId);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @PutMapping("/reservations/{reservationId}/finish")
    public ResponseEntity<Void> finishReservation(
            @PathVariable Long reservationId,
            @AuthenticationPrincipal User user) {
        localWorkerService.finishReservation(user.getId(), reservationId);
        return new ResponseEntity<>(HttpStatus.OK);
    }

}
