package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.dto.localDTO.CreateLocalDetailsDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DisplayLocalDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DisplayLocalDetailsDTO;
import mk.ukim.finki.it.reservengo.model.domain.User;
import mk.ukim.finki.it.reservengo.service.intf.LocalManagerService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@RestController
@RequestMapping("/api/local-managers")
@PreAuthorize("hasRole('LOCAL_MANAGER')")
public class LocalManagerController {

    private final LocalManagerService localManagerService;

    public LocalManagerController(LocalManagerService localManagerService) {
        this.localManagerService = localManagerService;
    }

    @PostMapping("/{localId}/upload-logo")
    public ResponseEntity<Void> uploadLogo(@PathVariable Long localId,
                                           @RequestParam("logo") MultipartFile logoFile) {
        localManagerService.uploadLocalLogo(localId, logoFile);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping("/{localId}/delete-logo")
    public ResponseEntity<Void> deleteLocalLogo(@PathVariable Long localId) {
        localManagerService.deleteLocalLogo(localId);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @PostMapping("/{localId}/upload-menu")
    public ResponseEntity<Void> uploadMenu(@PathVariable Long localId,
                                           @RequestParam("menu") MultipartFile menuFile) {
        localManagerService.uploadLocalMenu(localId, menuFile);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping("/{localId}/delete-menu")
    public ResponseEntity<Void> deleteMenu(@PathVariable Long localId) {
        localManagerService.deleteLocalMenuPhoto(localId);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @PostMapping("/{localId}/upload-photos")
    public ResponseEntity<Void> uploadPhotos(@PathVariable Long localId,
                                             @RequestParam("photos") List<MultipartFile> photos) {
        localManagerService.uploadLocalPhotos(localId, photos);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping("/{localId}/delete-photos")
    public ResponseEntity<Void> deletePhotos(@PathVariable Long localId,
                                             @RequestParam("photos") List<String> photoPaths) {
        localManagerService.deleteLocalPhotos(localId, photoPaths);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    @GetMapping("/my-local")
    public ResponseEntity<DisplayLocalDTO> getLocalForManager(@AuthenticationPrincipal User user) {
        DisplayLocalDTO displayLocalDTO = DisplayLocalDTO.fromLocal(localManagerService.findLocalByManagerId(user.getId()));
        return new ResponseEntity<>(displayLocalDTO, HttpStatus.OK);
    }

    @GetMapping("/my-local/edit")
    public ResponseEntity<DisplayLocalDetailsDTO> getLocalInformation(@AuthenticationPrincipal User user) {
        DisplayLocalDetailsDTO displayLocalDetailsDTO = DisplayLocalDetailsDTO.from(localManagerService.findLocalByManagerId(user.getId()));
        return new ResponseEntity<>(displayLocalDetailsDTO, HttpStatus.OK);
    }

    @PostMapping("/{localId}/edit")
    public ResponseEntity<Void> editLocalInformation(@PathVariable Long localId,
                                                     @RequestBody CreateLocalDetailsDTO createLocalDetailsDTO) {
        localManagerService.editLocalInfo(localId, createLocalDetailsDTO);
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }
}
