package mk.ukim.finki.it.reservengo.dto.eventDTO;

import mk.ukim.finki.it.reservengo.model.domain.Event;
import mk.ukim.finki.it.reservengo.model.enumerations.EventStatus;

import java.time.LocalDateTime;
import java.util.List;

public record DisplayEventDTO(
        Long id,
        String name,
        String description,
        LocalDateTime eventStart,
        LocalDateTime eventEnd,
        Long localId,
        EventStatus eventStatus
) {
    public static DisplayEventDTO fromEvent(Event event) {
        return new DisplayEventDTO(
                event.getId(),
                event.getName(),
                event.getDescription(),
                event.getEventStart(),
                event.getEventEnd(),
                event.getLocal().getId(),
                event.getStatus()
        );
    }

    public static List<DisplayEventDTO> fromEvents(List<Event> events) {
        return events.stream()
                .map(DisplayEventDTO::fromEvent)
                .toList();
    }
}
