import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

class UserManager {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }


  getProfile(): Promise<any> {
    return this.httpClient.get('profile');
  }

  updateProfile(payload: { firstName: string; lastName: string; phoneNumber: string }): Promise<any> {
    return this.httpClient.put('edit', payload);
  }

  changeEmail(payload: { newEmail: string }): Promise<any> {
    return this.httpClient.patch('change-email', payload);
  }

  changePassword(payload: { currentPassword: string; newPassword: string }): Promise<any> {
    return this.httpClient.patch('change-password', payload);
  }

  uploadAvatar(formData: FormData): Promise<any> {
    return this.httpClient.upload('upload-avatar', formData);
  }

  deleteAvatar(): Promise<any> {
    return this.httpClient.delete('delete-avatar');
  }
  disableUserAccount(): Promise<any> {
    return this.httpClient.patch('disable');
  }
}

export const useUser = new UserManager(BASE_API_URL + '/api/user/')
