import { readonly, reactive } from 'vue'

const toasts = reactive([])

function showToast(message, type = 'success', duration = 5000) {
  const id = Date.now() + Math.random()

  toasts.push({
    id,
    message,
    type,
    duration,
  })
}

function removeToast(id) {
  const index = toasts.findIndex((toast) => toast.id === id)
  if (index > -1) {
    toasts.splice(index, 1)
  }
}

export function useToasts() {
  return {
    toasts: readonly(toasts),
    showToast,
    removeToast,
  }
}
