import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

class EventsRepository {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  listAll(): Promise<any> {
    return this.httpClient.get()
  }
}

export const useEvents = new EventsRepository(BASE_API_URL + '/api/events')
