package mk.ukim.finki.it.reservengo.web;

import mk.ukim.finki.it.reservengo.dto.userDTO.CreateUserDTO;
import mk.ukim.finki.it.reservengo.model.domain.User;
import mk.ukim.finki.it.reservengo.service.intf.UserService;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping("/api/user")
public class UserController {

    private final UserService userService;

    public UserController(UserService userService) {
        this.userService = userService;
    }

    @GetMapping("/info")
    public ResponseEntity<?> getUserPersonalInfo(@AuthenticationPrincipal User user) {
        User u = userService.findUser(user.getId());
        return ResponseEntity.ok(u);
    }

    @PutMapping("/{userId}/edit-info")
    public ResponseEntity<?> editPersonalInfo(@PathVariable Long userId, @RequestBody CreateUserDTO createUserDTO) {
        User user = userService.editUserInfo(userId, createUserDTO);
        return ResponseEntity.ok(user);
    }
}
