// src/repository/user.ts (or wherever you keep the file)
import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

class UserManager { // Renamed for clarity, but you can keep LocalManager
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  // --- NEW METHODS BASED ON YOUR COMPONENT'S FETCH CALLS ---

  getProfile(): Promise<any> {
    return this.httpClient.get('profile');
  }

  updateProfile(payload: { firstName: string; lastName: string; phoneNumber: string }): Promise<any> {
    return this.httpClient.put('edit', payload);
  }

  changeEmail(payload: { newEmail: string }): Promise<any> {
    return this.httpClient.patch('change-email', payload);
  }

  changePassword(payload: { currentPassword: string; newPassword: string }): Promise<any> {
    return this.httpClient.patch('change-password', payload);
  }

  uploadAvatar(formData: FormData): Promise<any> {
    return this.httpClient.upload('upload-avatar', formData);
  }

  deleteAvatar(): Promise<any> {
    return this.httpClient.delete('delete-avatar');
  }
}

export const useUser = new UserManager(BASE_API_URL + '/api/user/')
