package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.dto.userDTO.*;
import mk.ukim.finki.it.reservengo.model.domain.User;
import mk.ukim.finki.it.reservengo.service.intf.UserService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;


@RestController
@RequestMapping("/api/user")
public class UserController {

    private final UserService userService;

    public UserController(UserService userService) {
        this.userService = userService;
    }

    @GetMapping("/profile")
    public ResponseEntity<DisplayUserDTO> getProfile(@AuthenticationPrincipal User user) {
        DisplayUserDTO displayUserDTO = DisplayUserDTO.fromUser(userService.findUserById(user.getId()));
        return new ResponseEntity<>(displayUserDTO, HttpStatus.OK);
    }

    @PutMapping("/edit")
    public ResponseEntity<DisplayUserDTO> editProfile(@AuthenticationPrincipal User user, @RequestBody EditUserProfileDTO editUserProfileDTO) {
        DisplayUserDTO displayUserDTO = DisplayUserDTO.fromUser(userService.editUser(user.getId(), editUserProfileDTO));
        return new ResponseEntity<>(displayUserDTO, HttpStatus.OK);
    }

    @PatchMapping("/change-email")
    public ResponseEntity<DisplayUserEmailDTO> changeEmail(@AuthenticationPrincipal User user, @RequestBody EditUserEmailDTO editUserEmailDTO) {
        DisplayUserEmailDTO displayUserEmailDTO = userService.changeEmail(user.getId(), editUserEmailDTO);
        return new ResponseEntity<>(displayUserEmailDTO, HttpStatus.OK);
    }

    @PatchMapping("/change-password")
    public ResponseEntity<Void> changePassword(@AuthenticationPrincipal User user, @RequestBody EditUserPasswordDTO editUserPasswordDTO) {
        userService.changePassword(user.getId(), editUserPasswordDTO);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @PostMapping("/upload-avatar")
    public ResponseEntity<String> uploadLogo(@AuthenticationPrincipal User user,
                                             @RequestParam("avatar") MultipartFile logoFile) {
        String logoUrl = userService.uploadProfilePhoto(user.getId(), logoFile);
        return new ResponseEntity<>(logoUrl, HttpStatus.OK);
    }

    @DeleteMapping("/delete-avatar")
    public ResponseEntity<Void> deleteLocalLogo(@AuthenticationPrincipal User user) {
        userService.deleteProfilePhoto(user.getId());
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @PatchMapping("/disable")
    public ResponseEntity<Void> disableUser(@AuthenticationPrincipal User user) {
        userService.disableProfile(user.getId());
        return new ResponseEntity<>(HttpStatus.OK);
    }
}
