



export class HttpClient {

  constructor(baseURL) {
    this.baseURL = baseURL;
  }


  async baseFetch(endpoint, { method = 'GET', headers = {}, body, queryParams } = {}) {
    const url = new URL(endpoint, this.baseURL);



    if (queryParams) {
      Object.entries(queryParams).forEach(([k, v]) => url.searchParams.append(k, v));
    }

    const finalHeaders = { ...headers };

    //Crutial code, adds the jwt, maybe to be changed later.
    const nonParsed = localStorage.getItem('userData');
    if (nonParsed) {
      const token = JSON.parse(nonParsed).token;
      if (token) {
        finalHeaders['Authorization'] = `Bearer ${token}`;
      }
    }

    const config = { method, headers: finalHeaders, body };

   /* console.warn(config);*/

   /* console.warn(url.toString());*/

    const res = await fetch(url.toString(), config);
    const clonedRes = res.clone();

    const contentType = res.headers.get('Content-Type') || '';

    let parsed;

    try {
      if (contentType.includes('application/json')) {
        parsed = await res.json();
      } else if (contentType.startsWith('text/')) {
        parsed = await res.text();
      } else {
        parsed = await res.blob();
      }
    } catch (err) {
      console.warn('Error parsing response body:', err);
      parsed = null;
    }

    if (!res.ok) {
      const error = new Error(`Request failed with status ${res.status}`);
      error.status = res.status;
      error.statusText = res.statusText;
      error.url = url.toString();
      error.response = parsed;      // <--- THIS LINE
      error.rawResponse = clonedRes;
      throw error;
    }

    return parsed;
  }



  json(endpoint, method, data = null, options = {}) {
    return this.baseFetch(endpoint, {
      ...options,
      method,
      headers: {
        'Content-Type': 'application/json',
        ...(options.headers || {}),
      },
      body: data ? JSON.stringify(data) : undefined,
    });
  }

  form(endpoint, method, formData, options = {}) {
    return this.baseFetch(endpoint, {
      ...options,
      method,
      body: formData,
      headers: {
        ...(options.headers || {}),
      },
    });
  }

  get(endpoint, options = {}) {
    const config = {
      ...options,
      method: 'GET',
      body: undefined,
    };
    return this.baseFetch(endpoint, config);
  }

  post(endpoint, data, options = {}) {
    return this.json(endpoint, 'POST', data, options);
  }

  put(endpoint, data, options = {}) {
    return this.json(endpoint, 'PUT', data, options);
  }

  delete(endpoint, options = {}) {
    return this.json(endpoint, 'DELETE', null, options);
  }

  upload(endpoint, formData, options = {}) {
    return this.form(endpoint, 'POST', formData, options);
  }

  async fetchImageAsBase64(imagePath) {
    try {
      console.warn(`Fetching image as Base64 using baseFetch from: ${imagePath}`);
      const blob = await this.baseFetch(imagePath, { method: 'GET' });

      // Ensure that the response is indeed a Blob
      if (!(blob instanceof Blob)) {
        throw new Error("Expected a Blob response, but received a different type. Check Content-Type header.");
      }

      return new Promise((resolve, reject) => {
        const reader = new FileReader();
        reader.onloadend = () => {
          if (typeof reader.result === 'string') {
            resolve(reader.result); // This is the base64 string
          } else {
            reject(new Error("FileReader did not return a string result for Base64 conversion."));
          }
        };
        reader.onerror = (error) => {
          console.error("FileReader error:", error);
          reject(new Error("Failed to read image as Base64."));
        };
        reader.readAsDataURL(blob); // Convert blob to base64 data URL
      });

    } catch (err) {
      console.error("Error fetching or converting image to Base64:", err);
      throw err; // Re-throw the error for the caller to handle
    }
  }

}
