import { ApiClient } from '@/Api_Classes/ApiClient'
import { config } from '@/constants/Api_config'

const BASE_API_URL =  config.API_BASE_URL

/*
console.warn("THIS IS THE BASE URL",BASE_API_URL)
*/


class LocalManager extends ApiClient {
  private readonly endpoint: string

  constructor(baseUrl : string, endpoint : string) {
    super(baseUrl)
    this.endpoint = endpoint
  }

  uploadLogo(formData : FormData) : Promise<any> {
    return this.httpClient.upload(this.endpoint + '/upload-logo', formData)
  }



}


export const useLocalManager = new LocalManager(BASE_API_URL, "/api/local-manager")
