import { ApiClient } from '@/Api_Classes/ApiClient'
import { config } from '@/constants/Api_config'

const BASE_API_URL =  config.API_BASE_URL

class Utility extends ApiClient {
  private readonly endpoint: string

  constructor(baseUrl : string) {
    super(baseUrl)
  }

  fetchImageBase64(imagePath : string) : Promise<any> {
    return this.httpClient.fetchImageAsBase64(imagePath);
  }




}


export const useUtility = new Utility(BASE_API_URL)
