import { defineStore } from 'pinia'

export const userStore = defineStore('userStore', {

  state() {
    return {
      data: {
        id: 0,
        firstName: "",
        lastName: "",
        email: "",
        phoneNumber: "",
        role: "UN_AUTHENTICATED",
        token: null,
        logoUrl: null,
        profilePictureBase64Encoded: null
      }

    }
  },
  actions: {

    setLocalStorage(jsonObject) {

      this.data = jsonObject
      //this.data.profilePictureBase64Encoded =

      if (this.data.logoUrl != null) {
        fetch('http://localhost:8080' + this.data.logoUrl, {
          headers: {
            Authorization: this.getToken,
          }
        })
          .then(response => response.blob())
          .then(blob => {
            const reader = new FileReader();
            reader.onloadend = () => {
              const base64data = reader.result;

              this.setProfilePicturePathToLocalStorage(this.data.logoUrl, base64data)
            };
            reader.readAsDataURL(blob);
          })
          .catch(err => console.log("Error parsing the blob", err))

      }


      localStorage.setItem('userData', JSON.stringify(jsonObject));

    },
    removeProfilePictureFromLocaleStorage() {
      this.data.profilePictureBase64Encoded = null;
      this.data.logoUrl = null;
      localStorage.setItem('userData', JSON.stringify(this.data));
    },

    setNewEditedDataToLocalStorage(jsonObject) {
      const {firstName, lastName, phoneNumber} = jsonObject;
      this.data.firstName = firstName;
      this.data.lastName = lastName;
      this.data.phoneNumber = phoneNumber;

      localStorage.setItem('userData', JSON.stringify(this.data));
    },
    setNewEmailToLocalStorage(jsonObject) {
      const {email, jwt} = jsonObject;
      this.data.email = email;
      this.data.token = jwt;

      localStorage.setItem('userData', JSON.stringify(this.data));
    },
    setProfilePicturePathToLocalStorage(profilePicturePath, base64Encoded) {
      this.data.logoUrl = profilePicturePath;
      this.data.profilePictureBase64Encoded = base64Encoded;
      localStorage.setItem('userData', JSON.stringify(this.data));
    },
    getLocalStorage() {
      let nonparsed = localStorage.getItem('userData');
      if (nonparsed !== null) {
        this.data = JSON.parse(nonparsed);
      }
    },
    clearLocalStorage() {

      this.data =  {
        id: 0,
        firstName: "",
        lastName: "",
        email: "",
        phoneNumber: "",
        role: "UN_AUTHENTICATED",
        token: null,
        logoUrl: null,
        profilePictureBase64Encoded: null
      }
      localStorage.setItem('userData', JSON.stringify(this.data));

    }
  },
  getters: {
    getToken(){
      return 'Bearer ' + this.data.token;
    }
  }
})
