import { createRouter, createWebHistory } from 'vue-router'

import home_ from '@/components/Project/Restaurant/home_.vue'
import login_ from '@/components/Project/Auth/login_.vue'
import register_ from '@/components/Project/Auth/register_.vue'
import my_reservations from '@/components/Project/Reservation/My_reservations.vue'
import Locale_ from '@/components/Project/Restaurant/Locale_.vue'
import Profile_Page from '@/components/Project/Customer/Profile_Page.vue'
import AdminDashboard from '@/components/Project/Admin/AdminDashboard.vue'
import LocaleNotAssigned from '@/components/Project/Manager/locale-not-assigned.vue'
import ManagerDashboard from '@/components/Project/Manager/ManagerDashboard.vue'
import Locale_listing_container from '@/components/Project/Restaurant/Locale_listing_container.vue'
import DisabledAccountPage from '@/components/Project/Auth/DisabledAccountPage.vue'
import WorkerReservationsDashboard from '@/components/Project/Worker/WorkerReservationsDashboard.vue'
import AboutUs from '@/components/Project/StaticPages/AboutUs.vue'
import ContactComp from '@/components/Project/StaticPages/ContactComp.vue'
import PrivacyPolicy from '@/components/Project/StaticPages/PrivacyPolicy.vue'

const router = createRouter({
  history: createWebHistory(import.meta.env.BASE_URL),
  routes: [
    {
      path: '/favourite_locals/:mode',
      name: 'favourite_locals',
      component: Locale_listing_container,
      props: true,
    },
    {
      path: '/my_reservations',
      name: 'my reservations',
      component: my_reservations,
    },
    {
      path: '/',
      name: 'home',
      component: home_,
    },
    {
      path: '/login',
      name: 'login',
      component: login_,
    },
    {
      path: '/register/:userType?',
      name: 'register',
      component: register_,
    },
    {
      path: '/more_details/:id',
      name: 'more_details',
      component: Locale_,
    },
    {
      path: '/more_details',
      name: 'LocaleNotAssigned',
      component: LocaleNotAssigned,
    },

    {
      path: '/profilePage',
      name: 'profilePage',
      component: Profile_Page,
    },
    {
      path: '/admin-dashboard',
      name: 'admin-dashboard',
      component: AdminDashboard,
    },
    {
      path: '/manager-dashboard',
      name: 'manager-dashboard',
      component: ManagerDashboard,
    },
    {
      path: '/disabledAccountPage',
      name: 'disabledAccountPage',
      component: DisabledAccountPage,
    },
    {
      path: '/worker-reservations-dashboard',
      name: 'worker-reservations-dashboard',
      component: WorkerReservationsDashboard,
    },
    {
      path: '/about-us',
      name: 'about-us',
      component: AboutUs,
    },
    {
      path: '/contact',
      name: 'contact',
      component: ContactComp,
    },
    {
      path: '/privacy-policy',
      name: 'privacy-policy',
      component: PrivacyPolicy,
    },
  ],
})

export default router
