package mk.ukim.finki.it.reservengo.bootstrap;

import jakarta.annotation.PostConstruct;
import mk.ukim.finki.it.reservengo.model.*;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;
import mk.ukim.finki.it.reservengo.model.enumerations.Service;
import mk.ukim.finki.it.reservengo.repository.*;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class DataHolder {
    public static Admin admin = null;
    public static List<Customer> customers = new ArrayList<>();
    public static List<LocalWorker> workers = new ArrayList<>();
    public static List<LocalManager> managers = new ArrayList<>();
    public static List<Local> locals = new ArrayList<>();

    private final AdminRepository adminRepository;
    private final CustomerRepository customerRepository;
    private final LocalManagerRepository localManagerRepository;
    private final LocalRepository localRepository;
    private final LocalWorkerRepository localWorkerRepository;
    private final PasswordEncoder passwordEncoder;

    public DataHolder(AdminRepository adminRepository, CustomerRepository customerRepository, LocalManagerRepository localManagerRepository, LocalRepository localRepository, LocalWorkerRepository localWorkerRepository, PasswordEncoder passwordEncoder) {
        this.adminRepository = adminRepository;
        this.customerRepository = customerRepository;
        this.localManagerRepository = localManagerRepository;
        this.localRepository = localRepository;
        this.localWorkerRepository = localWorkerRepository;
        this.passwordEncoder = passwordEncoder;
    }

    @PostConstruct
    public void init() {
        // Admin
        admin = new Admin("admin", passwordEncoder.encode("admin"), Role.ROLE_ADMIN);
        adminRepository.save(admin);

        // Customers
        for (int i = 1; i <= 3; i++) {
            Customer customer = new Customer(
                    "FirstName " + i,
                    "LastName " + i,
                    "customer" + i + "@example.com",
                    passwordEncoder.encode("password" + i),
                    "Phone" + i,
                    Role.ROLE_CUSTOMER
            );
            customers.add(customer);
        }
        customerRepository.saveAll(customers);

        //Local worker
        for (int i = 1; i <= 3; i++) {
            LocalWorker localWorker = new LocalWorker(
                    "FirstName" + i,
                    "LastName" + i,
                    "worker" + i + "@example.com",
                    passwordEncoder.encode("password" + i),
                    "Phone" + i,
                    Role.ROLE_LOCAL_WORKER
            );
            workers.add(localWorker);
        }
        localWorkerRepository.saveAll(workers);

        //Local manager
        for (int i = 1; i <= 3; i++) {
            LocalManager manager = new LocalManager(
                    "FirstName" + i,
                    "LastName" + i,
                    "manager" + i + "@example.com",
                    passwordEncoder.encode("password" + i),
                    "Phone" + i,
                    Role.ROLE_LOCAL_MANAGER
            );
            managers.add(manager);
        }
        localManagerRepository.saveAll(managers);

        //Local
        List<Service> serviceList = new ArrayList<>(List.of(Service.values()));
        List<String> localPhotos;
        for (int i = 1; i <= 3; i++) {
            localPhotos = new ArrayList<>();
            for (int j = 1; j <= 3; j++) {
                localPhotos.add("PicturePath: " + j);
            }
            Local local = new Local(
                    "Name" + i,
                    "Description" + i,
                    "Address" + i,
                    "WorkingHours" + i,
                    serviceList,
                    null,
                    null,
                    localPhotos,
                    "MenuPhotoPath" + i,
                    "MenuLink" + i,
                    null,
                    null,
                    null
            );
            locals.add(local);
        }
        localRepository.saveAll(locals);
    }
}