package mk.ukim.finki.it.reservengo.dto.workerDTO;

import mk.ukim.finki.it.reservengo.model.domain.LocalWorker;
import mk.ukim.finki.it.reservengo.model.enumerations.Position;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;

import java.util.List;

public record DisplayWorkerDTO(
        Long id,
        String firstName,
        String lastName,
        String email,
        String phoneNumber,
        Role role,
        Position position
) {
    public static DisplayWorkerDTO fromWorker(LocalWorker worker) {
        return new DisplayWorkerDTO(
                worker.getId(),
                worker.getFirstName(),
                worker.getLastName(),
                worker.getEmail(),
                worker.getPhoneNumber(),
                worker.getUserRole(),
                worker.getPosition()
        );
    }

    public static List<DisplayWorkerDTO> fromWorkers(List<LocalWorker> workers) {
        return workers.stream()
                .map(DisplayWorkerDTO::fromWorker)
                .toList();
    }
}
