package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.model.domain.LocalWorker;
import mk.ukim.finki.it.reservengo.model.enumerations.Position;
import mk.ukim.finki.it.reservengo.model.exceptions.UserEmailAlreadyExistsException;
import mk.ukim.finki.it.reservengo.model.exceptions.WorkerIdNotFoundException;
import mk.ukim.finki.it.reservengo.repository.LocalWorkerRepository;
import mk.ukim.finki.it.reservengo.service.intf.LocalWorkerService;
import mk.ukim.finki.it.reservengo.service.intf.UserService;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class LocalWorkerServiceImpl implements LocalWorkerService {
    private final LocalWorkerRepository localWorkerRepository;
    private final UserService userService;

    public LocalWorkerServiceImpl(LocalWorkerRepository localWorkerRepository, UserService userService) {
        this.localWorkerRepository = localWorkerRepository;
        this.userService = userService;
    }

    @Override
    public void save(LocalWorker localWorker) {
        if (userService.emailExists(localWorker.getEmail())) {
            throw new UserEmailAlreadyExistsException(localWorker.getEmail());
        }
        localWorkerRepository.save(localWorker);
    }

    @Override
    public LocalWorker findWorkerById(Long id) {
        return localWorkerRepository.findById(id).orElseThrow(() -> new WorkerIdNotFoundException(id));
    }

    @Override
    public void changePosition(LocalWorker worker, Position position) {
        worker.setPosition(position);
        localWorkerRepository.save(worker);
    }

    @Override
    public List<LocalWorker> findAllByLocalId(Long id) {
        return localWorkerRepository.findByLocal_Id(id);
    }

    @Override
    public List<LocalWorker> findAllUnassigned() {
        return localWorkerRepository.findAll().stream()
                .filter(worker -> worker.getLocal() == null)
                .filter(worker -> worker.getPosition() == null)
                .collect(Collectors.toList());
    }

    @Override
    public void updateLocalAssignment(LocalWorker worker, Local local) {
        worker.setLocal(local);
        if (local == null) {
            worker.setPosition(null);
        }

        localWorkerRepository.save(worker);
    }
}
